/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.io.codecs.macbinary.decoding.macos;

import com.apple.mrj.macos.libraries.InterfaceLib;
import com.apple.mrj.macos.toolbox.FSSpec;
import com.apple.mrj.macos.toolbox.Toolbox;
import com.zerog.common.io.codecs.macbinary.common.MacFileInfo;
import com.zerog.common.io.codecs.macbinary.decoding.macos.MacHandle;
import com.zerog.common.io.codecs.macbinary.util.MacStringUtil;
import java.io.IOException;

public class CommentsWriter
extends MacHandle
implements InterfaceLib {
    public static final int AFP_ITEM_NOT_FOUND = -5012;
    public static final int MAX = 200;
    public static final int DTPBRec = 104;
    public static final int IONameStr = 64;
    public static final int CommentText = 256;
    public static final int NAMEBUF_AT = 104;
    public static final int TEXTBUF_AT = 168;
    public static final int SIZE = 424;
    public static final int NAMEPTR_AT = 18;
    public static final int VREFNUM_AT = 22;
    public static final int DTREFNUM_AT = 24;
    public static final int DTBUFPTR_AT = 32;
    public static final int DTREQCOUNT_AT = 36;
    public static final int DTACTUALCOUNT_AT = 40;
    public static final int DIR_ID_AT = 48;
    private static CommentsWriter dtAccess = new CommentsWriter();
    private String name = "";
    private byte[] comments = MacFileInfo.EMPTY_COMMENTS;

    public String toString() {
        return this.name;
    }

    public CommentsWriter() {
        super(424);
    }

    public void setTarget(FSSpec fSSpec) {
        String string = fSSpec.getName();
        this.prepVol(fSSpec.getVRefNum());
        this.setIntAt(48, fSSpec.getParID());
        if (string == null) {
            string = "";
        }
        this.setBytesAt(104, MacStringUtil.toPStr(string, 63));
        this.name = string;
    }

    public void setComments(byte[] byArray) {
        this.comments = byArray;
    }

    public void write() throws IOException {
        boolean bl;
        boolean bl2 = bl = this.comments != null && this.comments.length > 0;
        if (this.getShortAt(24) != 0) {
            try {
                short s;
                int n = 0;
                if (bl) {
                    n = this.comments.length;
                    if (n > 200) {
                        n = 200;
                        byte[] byArray = new byte[n];
                        System.arraycopy(this.comments, 0, byArray, 0, n);
                        this.comments = byArray;
                    }
                    this.setBytesAt(168, this.comments);
                }
                this.setIntAt(36, n);
                int n2 = this.lockedPointer();
                this.setIntAt(18, n2 + 104);
                this.setIntAt(32, n2 + 168);
                Toolbox toolbox = Toolbox.LOCK;
                synchronized (toolbox) {
                    s = bl ? CommentsWriter.PBDTSetCommentSync(n2) : CommentsWriter.PBDTRemoveCommentSync(n2);
                }
                if (!bl && s == -5012) {
                    s = 0;
                }
                this.checkIOErr(s);
                Toolbox toolbox2 = Toolbox.LOCK;
                synchronized (toolbox2) {
                    s = CommentsWriter.PBDTFlushSync(n2);
                }
                this.checkIOErr(s);
                Object var9_10 = null;
                this.unlock();
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.unlock();
                throw throwable;
            }
        }
    }

    private void prepVol(short s) {
        this.eraseAll();
        this.setShortAt(22, s);
        try {
            int n = this.lockedPointer();
            this.setIntAt(18, n + 104);
            Toolbox toolbox = Toolbox.LOCK;
            synchronized (toolbox) {
                if (CommentsWriter.PBDTGetPath(n) != 0) {
                    this.setShortAt(24, (short)0);
                }
            }
            Object var6_5 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.unlock();
            throw throwable;
        }
        this.setShortAt(22, s);
    }

    private static native short PBDTGetPath(int var0);

    private static native short PBDTSetCommentSync(int var0);

    private static native short PBDTRemoveCommentSync(int var0);

    private static native short PBDTFlushSync(int var0);
}

