/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.io.codecs.macbinary.decoding.macos;

import com.apple.mrj.jdirect.GenericPointer;
import com.apple.mrj.macos.libraries.InterfaceLib;
import com.apple.mrj.macos.toolbox.FSSpec;
import com.apple.mrj.macos.toolbox.Toolbox;
import com.zerog.common.io.codecs.macbinary.common.MacFileInfo;
import com.zerog.common.io.codecs.macbinary.decoding.macos.MacHandle;
import com.zerog.common.io.codecs.macbinary.util.MacStringUtil;
import com.zerog.common.io.codecs.macbinary.util.MacTime;
import com.zerog.common.io.codecs.macbinary.util.MemoryException;
import java.io.IOException;

public class MacClassicInfo
extends MacHandle
implements InterfaceLib {
    public static final int SIZE = 364;
    public static final int STRBUF_AT = 108;
    public static final int NAMEPTR_AT = 18;
    public static final int VREFNUM_AT = 22;
    public static final int DIR_INDEX_AT = 28;
    public static final int ATTRIB_AT = 30;
    public static final int DIR_ID_AT = 48;
    public static final int PARENT_DIR_ID_AT = 100;
    public static final int FINFO_AT = 32;
    public static final int FILE_TYPE_AT = 32;
    public static final int FILE_CREATOR_AT = 36;
    public static final int FINFO_FLAGS_AT = 40;
    public static final int FINFO_VERT_AT = 42;
    public static final int FINFO_HORZ_AT = 44;
    public static final int WHEN_CREATED_AT = 72;
    public static final int WHEN_MODIFIED_AT = 76;
    public static final int FXINFO_AT = 84;
    public static final int FXINFO_SCRIPT_AT = 92;
    public static final int FXINFO_FLAGS_AT = 93;
    private GenericPointer myRef;
    private boolean shouldLockFile = false;
    private FSSpec target = null;

    public MacClassicInfo() throws MemoryException {
        super(364);
    }

    public final void setTarget(FSSpec fSSpec) {
        this.target = fSSpec;
        this.setShortAt(22, fSSpec.getVRefNum());
        this.setIntAt(48, fSSpec.getParID());
        this.setShortAt(28, (short)0);
        this.setIntAt(100, fSSpec.getParID());
        String string = fSSpec.getName();
        if (string == null) {
            this.setByteAt(108, (byte)0);
        } else {
            this.setBytesAt(108, MacStringUtil.toPStr(string, 255));
        }
    }

    public final void write() throws IOException {
        short s;
        try {
            int n = this.lockedPointer();
            this.setIntAt(18, n + 108);
            Toolbox toolbox = Toolbox.LOCK;
            synchronized (toolbox) {
                s = MacClassicInfo.PBSetCatInfoSync(n);
            }
            this.checkIOErr(s);
            Object var6_6 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.unlock();
            throw throwable;
        }
        if (this.shouldLockFile) {
            Toolbox toolbox = Toolbox.LOCK;
            synchronized (toolbox) {
                s = MacClassicInfo.FSpSetFLock(this.target.getBytes());
            }
            this.checkIOErr(s);
        }
    }

    public void readFrom(MacFileInfo macFileInfo) {
        if (macFileInfo == null) {
            return;
        }
        this.setIntAt(32, macFileInfo.getFileType());
        this.setIntAt(36, macFileInfo.getFileCreator());
        this.setShortAt(40, (short)macFileInfo.getFinderFlags());
        this.setByteAt(93, (byte)(macFileInfo.getFinderFlags() >> 16));
        this.setIntAt(72, (int)MacTime.javaMillisToMacSecs(macFileInfo.getTimeCreated()));
        this.setIntAt(76, (int)MacTime.javaMillisToMacSecs(macFileInfo.getTimeModified()));
        this.setShortAt(44, macFileInfo.getFinderIconXAt());
        this.setShortAt(42, macFileInfo.getFinderIconYAt());
        this.shouldLockFile = macFileInfo.isLocked();
    }

    private static native short PBSetCatInfoSync(int var0);

    private static native short FSpSetFLock(byte[] var0);
}

