/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.io.codecs.macbinary.util;

public class Byter {
    private byte[] myBytes;

    public Byter() {
    }

    public Byter(int n) {
        this(new byte[n]);
    }

    public Byter(byte[] byArray) {
        this();
        this.setByteArray(byArray);
    }

    public final byte[] getByteArray() {
        return this.myBytes;
    }

    public final void setByteArray(byte[] byArray) {
        this.myBytes = byArray;
    }

    public void clear() {
        if (this.myBytes != null) {
            int n = 0;
            while (n < this.myBytes.length) {
                this.myBytes[n] = 0;
                ++n;
            }
        }
    }

    public byte getByteAt(int n) {
        return this.myBytes[n];
    }

    public int getUByteAt(int n) {
        return 0xFF & this.myBytes[n];
    }

    public short getShortAt(int n) {
        return (short)((this.myBytes[n] << 8) + (0xFF & this.myBytes[n + 1]));
    }

    public int getUShortAt(int n) {
        return (0xFF00 & this.myBytes[n] << 8) + (0xFF & this.myBytes[n + 1]);
    }

    public int getIntAt(int n) {
        int n2 = (0xFF & this.myBytes[n]) << 24;
        n2 += (0xFF & this.myBytes[n + 1]) << 16;
        return (n2 += (0xFF & this.myBytes[n + 2]) << 8) + (0xFF & this.myBytes[n + 3]);
    }

    public long getUIntAt(int n) {
        long l = 0xFFFFFFFFL & (long)this.getIntAt(n);
        return l;
    }

    public long getLongAt(int n) {
        long l = this.getIntAt(n);
        return (l << 32) + this.getUIntAt(n + 4);
    }

    public void putByteAt(byte by, int n) {
        this.myBytes[n] = by;
    }

    public void putBytesAt(byte[] byArray, int n) {
        System.arraycopy(byArray, 0, this.myBytes, n, byArray.length);
    }

    public void putBytesAt(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, 0, this.myBytes, n, n2);
    }

    public void putShortAt(short s, int n) {
        this.myBytes[n] = (byte)(s >> 8);
        this.myBytes[n + 1] = (byte)s;
    }

    public void putIntAt(int n, int n2) {
        this.myBytes[n2] = (byte)(n >> 24);
        this.myBytes[n2 + 1] = (byte)(n >> 16);
        this.myBytes[n2 + 2] = (byte)(n >> 8);
        this.myBytes[n2 + 3] = (byte)n;
    }

    public void putLongAt(long l, int n) {
        this.putIntAt((int)(l >> 32), n);
        this.putIntAt((int)l, n + 4);
    }
}

