/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.io.hfs;

import com.apple.mrj.macos.libraries.InterfaceLib;
import com.apple.mrj.macos.toolbox.FSSpec;
import com.apple.mrj.macos.toolbox.Toolbox;
import com.zerog.util.nativelib.macos.MacFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class FInfoFileOutputStreamJDi2
extends OutputStream
implements InterfaceLib {
    private ByteArrayOutputStream finderInfoOS = null;
    private boolean dirty = false;
    private FSSpec fileSpec;

    public FInfoFileOutputStreamJDi2(String string) throws IOException {
        this.fileSpec = new FSSpec(string);
        this.finderInfoOS = new ByteArrayOutputStream(16);
    }

    public FInfoFileOutputStreamJDi2(MacFile macFile) throws IOException {
        this((File)macFile);
    }

    public FInfoFileOutputStreamJDi2(File file) throws IOException {
        this(file.getPath());
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.dirty = true;
        this.finderInfoOS.write(byArray, n, n2);
    }

    public void write(byte[] byArray) throws IOException {
        this.dirty = true;
        this.finderInfoOS.write(byArray);
    }

    public void write(int n) throws IOException {
        this.dirty = true;
        this.finderInfoOS.write(n);
    }

    public void close() throws IOException {
        if (this.dirty) {
            byte[] byArray = this.finderInfoOS.toByteArray();
            Toolbox toolbox = Toolbox.LOCK;
            synchronized (toolbox) {
                FInfoFileOutputStreamJDi2.FSpSetFInfo(this.fileSpec.getBytes(), byArray);
            }
            ((OutputStream)this.finderInfoOS).close();
            this.finderInfoOS = null;
        }
    }

    private static native short FSpSetFInfo(byte[] var0, byte[] var1);
}

