/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.io.codecs.macbinary.common;

import com.zerog.common.io.codecs.macbinary.util.Byter;

public class MacBinarySecondaryHeader {
    public static final int HEADER_IDENTIFIER_OFFSET = 0;
    public static final int VERSION_MAJOR_OFFSET = 2;
    public static final int VERSION_MINOR_OFFSET = 3;
    public static final int LONG_NAME_LENGTH_OFFSET = 4;
    public static final int LONG_NAME_OFFSET = 6;
    private static final byte[] HEADER_IDENTIFIER = "ZG".getBytes();
    private static final byte VERSION_MAJOR = 1;
    private static final byte VERSION_MINOR = 0;
    private String longFileName = null;

    public MacBinarySecondaryHeader() {
    }

    public MacBinarySecondaryHeader(byte[] byArray) {
        this.readFromByteArray(byArray);
    }

    public String getLongFileName() {
        return this.longFileName;
    }

    public void setLongFileName(String string) {
        this.longFileName = string;
    }

    public void readFromByteArray(byte[] byArray) {
        short s;
        Byter byter = new Byter(byArray);
        if (byter.getByteAt(0) == HEADER_IDENTIFIER[0] && byter.getByteAt(1) == HEADER_IDENTIFIER[1] && byter.getByteAt(2) == 1 && (s = byter.getShortAt(4)) > 0 && s < byArray.length) {
            this.longFileName = new String(byArray, 6, (int)s);
        }
    }

    public byte[] getBytes() {
        byte[] byArray = null;
        if (this.longFileName != null && !"".equals(this.longFileName)) {
            byte[] byArray2 = this.longFileName.getBytes();
            Byter byter = new Byter(6 + byArray2.length);
            byter.putByteAt(HEADER_IDENTIFIER[0], 0);
            byter.putByteAt(HEADER_IDENTIFIER[1], 1);
            byter.putByteAt((byte)1, 2);
            byter.putByteAt((byte)0, 3);
            byter.putShortAt((short)byArray2.length, 4);
            byter.putBytesAt(byArray2, 6);
            byArray = byter.getByteArray();
        }
        return byArray;
    }
}

