/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.io.codecs.macbinary.decoding.macos;

import com.apple.mrj.jdirect.GenericPointer;
import com.apple.mrj.jdirect.HandleStruct;
import com.apple.mrj.macos.libraries.InterfaceLib;
import com.apple.mrj.macos.toolbox.Toolbox;
import com.zerog.common.io.codecs.macbinary.util.MemoryException;
import java.io.IOException;

public class MacHandle
extends HandleStruct
implements InterfaceLib {
    private GenericPointer myRef;

    public MacHandle(int n) throws MemoryException {
        super(0);
        short s;
        Toolbox toolbox = Toolbox.LOCK;
        synchronized (toolbox) {
            this.handle = MacHandle.NewHandleClear(n);
            s = MacHandle.MemError();
        }
        if (s != 0) {
            this.handle = 0;
            throw new MemoryException("MemError: " + s);
        }
        this.myRef = new GenericPointer(this.handle);
    }

    public void checkIOErr(int n) throws IOException {
        if (n != 0) {
            throw new IOException("Mac native Error, error code: " + n);
        }
    }

    public final int getSize() {
        if (this.handle == 0) {
            return 0;
        }
        Toolbox toolbox = Toolbox.LOCK;
        synchronized (toolbox) {
            int n = MacHandle.GetHandleSize(this.handle);
            return n;
        }
    }

    public void eraseAll() {
        int n = this.getSize();
        if ((n & 3) == 0) {
            int n2 = 0;
            while (n2 < n) {
                this.setIntAt(n2, 0);
                n2 += 4;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                this.setByteAt(n3, (byte)0);
                ++n3;
            }
        }
    }

    public final int lockedPointer() throws NullPointerException {
        if (this.handle == 0) {
            throw new NullPointerException("Null handle");
        }
        Toolbox toolbox = Toolbox.LOCK;
        synchronized (toolbox) {
            MacHandle.HLock(this.handle);
        }
        return this.myRef.getIntAt(0);
    }

    public final void unlock() {
        if (this.handle != 0) {
            Toolbox toolbox = Toolbox.LOCK;
            synchronized (toolbox) {
                MacHandle.HUnlock(this.handle);
            }
        }
    }

    public void finalize() {
        this.myRef = null;
        int n = this.handle;
        this.handle = 0;
        if (n != 0) {
            Toolbox toolbox = Toolbox.LOCK;
            synchronized (toolbox) {
                MacHandle.DisposeHandle(n);
            }
        }
    }

    private static native short MemError();

    private static native int NewHandleClear(int var0);

    private static native int GetHandleSize(int var0);

    private static native void HLock(int var0);

    private static native void HUnlock(int var0);

    private static native void DisposeHandle(int var0);
}

